<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is DELETE
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve the `id` from the query parameters
$id = $_POST['id'] ?? null;

// Validate the `id`
if (!$id) {
    echo json_encode(["status" => "error", "message" => "Enquiry ID is required"]);
    exit;
}

// Sanitize the `id` to prevent SQL injection
$id = intval($id);

// Update query to perform a soft delete by setting `Delete_status` to 1
$query = "UPDATE enquiry_form SET Delete_status = 1 WHERE id = $id";

// Execute the query
if (mysqli_query($conn, $query)) {
    if (mysqli_affected_rows($conn) > 0) {
        echo json_encode(["status" => "success", "message" => "Enquiry form deleted successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Enquiry form not found or already deleted"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete enquiry form"]);
}
?>
